@extends('layouts.list')

@section('title')
    All Submissions
@endsection

@section('list-title')
    Submissions
@endsection

@section('list-navigation')
    <li><a class="text-decoration-none" href="{{ route('allSubmissions') }}">List Submissions </a></li>
    <li>Search Submissions</li>
@endsection

@section('list-new-button')
    <a href="{{ route('createSubmission') }}" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i> New Submission
    </a>
@endsection

@section('list-table-header')
    <th scope="col">#</th>
    <th scope="col">Student Name</th>
    <th scope="col">Assignment Title</th>
    <th scope="col">Businss location</th>
    <th scope="col">Trainer</th>
    <th scope="col">Actions</th>
@endsection

@section('list-table-body')
    @foreach ($submissions as $submission)
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <td>
                <a class="text-decoration-none" href="{{ route('viewStudent', $submission->student_id) }}">
                    <p class="text-custome m-0 px-3">{{ $submission->student->student_name }}</p>
                </a>
            </td>
            <td>
                <a class="text-decoration-none" href="{{ route('viewAssignment', $submission->assignment_id) }}">
                    <p class="text-custome m-0 px-3">{{ $submission->assignment->assignment_title }}</p>
                </a>
            </td>
            <td>
                <a class="text-decoration-none" href="{{ route('viewTrainer', $submission->trainer_id) }}">
                    <p class="text-custome m-0 px-3">{{ $submission->trainer->full_name }}</p>
                </a>
            </td>
            <td>
                <a class="text-decoration-none" href="{{ route('viewBusinessLocation', $submission->business_id) }}">
                    <p class="text-custome m-0 px-3">{{ $submission->businessLocation->business_name }}</p>
                </a>
            </td>
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('viewSubmission', $submission->id) }}">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                View
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('editSubmission', $submission->id) }}">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                Edit
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('deleteSubmission', $submission->id) }}">
                                <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                Delete
                            </a>
                        </li>
                    </ul>
                </div>
            </td>
        </tr>
    @endforeach
@endsection

@section('list-table-inside-pagination')
    {{-- <div class="d-flex">
    {!! $submissions->links() !!}
</div> --}}
@endsection

@section('list-pagination')
    {{-- {{ $submissions->links() }} --}}
@endsection
